#ifndef UTILS_H
#define UTILS_H

#include <nostypes.h>
#include <stdint.h>

#include <vector>

#define CITADEL_DEV "/dev/citadel0"

#define MAX_RESPONSE_SIZE 2048

const size_t init_stack_size = 124;
static const uint8_t init_stack[init_stack_size] = {
    0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x00, 0xc0, 0xbd, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x91, 0x1a, 0x05, 0x00,
    0x08, 0x69, 0x01, 0x00, 0x08, 0x69, 0x01, 0x00, 0x34, 0x08, 0x34, 0x08,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00};

void print_vector(const std::vector<uint8_t> v);

uint32_t reset();

uint32_t generate_dump_blob();

int callNosCmd(const char* body, const nostypes::NosApp* app,
               const nostypes::NosCmd* cmd);

#endif
